//
//  OPEngineView.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/5/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPEngineView.h"
#import "OPMasterController.h"
#import "OPGameController.h"
#import "OPApplication.h"
#import "OPTypes.h"
#import <OpenGL/gl.h>
#import <GLUT/glut.h>


@implementation OPEngineView

- (id)initWithFrame:(NSRect)frameRect
{
	self = [super initWithFrame:frameRect];
	
	if(self != nil)
	{
		NSOpenGLPixelFormatAttribute WindowedAttributes[] =
		{
			NSOpenGLPFADoubleBuffer,
			NSOpenGLPFADepthSize, 32,
			NSOpenGLPFASingleRenderer,
			NSOpenGLPFAScreenMask, CGDisplayIDToOpenGLDisplayMask(kCGDirectMainDisplay),
			NSOpenGLPFANoRecovery,
			NSOpenGLPFAColorSize, 32,
			0
		};
		masterController = nil;
		NSOpenGLPixelFormat* windowedPixelFormat = [[[NSOpenGLPixelFormat alloc]
													 initWithAttributes:WindowedAttributes] autorelease];
		[self setPixelFormat:windowedPixelFormat];
		long sync = 1;
		[[self openGLContext] setValues: &sync forParameter: NSOpenGLCPSwapInterval];
	}
	
	runTimer = [[NSTimer scheduledTimerWithTimeInterval:0.0
												 target:self
											   selector:@selector(update)
											   userInfo:nil
												repeats:YES] retain];
	
    return self;
}

- (void)awakeFromNib
{
}

- (void)prepareOpenGL
{
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,	GL_LINEAR_MIPMAP_NEAREST );
	// when texture area is large, bilinear filter the original
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	
	// the texture wraps over at the edges (repeat)
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );
	masterController = [[OPMasterController alloc] init];
}

- (void)dealloc
{
	[masterController release];
	[super dealloc];
}

- (void)setFullScreenMode:(NSDictionary *)mode
{
}

- (void)reshape
{
	[[self openGLContext] update];
	NSSize viewSize = [self bounds].size;
	
	glViewport(0, 0, viewSize.width, viewSize.height);
	
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();
	glOrtho(0, GAME_WIDTH, 0, GAME_HEIGHT, -1, 1);
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

- (void)drawFrame
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear The Screen And The Depth Buffer
	glLoadIdentity();						// Reset The View
	
	glClearColor(0.0, 0.0, 0.0, 0.0);
	
	[masterController draw];
	
	[[self openGLContext] flushBuffer];
}

- (void)update
{
	static double lastFrameTime = 0.0;
	static double cyclesLeftOver = 0.0;
	double currentTime;
	double updateIterations;
	
	currentTime = [NSDate timeIntervalSinceReferenceDate];
	updateIterations = ((currentTime - lastFrameTime) + cyclesLeftOver);
	
	if(updateIterations > (MAX_CYCLES_PER_FRAME * UPDATE_INTERVAL)) {
		updateIterations = (MAX_CYCLES_PER_FRAME * UPDATE_INTERVAL);
	}
	
	while(updateIterations > UPDATE_INTERVAL) {
		updateIterations -= UPDATE_INTERVAL;
		[masterController update];		
	}

	cyclesLeftOver = updateIterations;
	lastFrameTime = currentTime;

	[self drawFrame];
}

- (IBAction)toggleFullScreen:(id)sender
{
}

- (void)drawRect:(NSRect)rect
{
	[self drawFrame];
}
@end


